package MusicLandscape.util.comparators;

import MusicLandscape.entities.Track;

import java.util.Comparator;

/**
 * Encapsulates the concept of comparing two tracks by duration.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since ExerciseSheet05
 */
public class DurationComparator implements Comparator<Track> {
    /**
     * Compares two tracks by duration.<br>
     * This comparator assumes non-null arguments.
     *
     * @param o1 the first object to be compared.
     * @param o2 the second object to be compared.
     * @return a negative integer, zero, or a positive integer as the
     * first argument is less than, equal to, or greater than the
     * second.
     * @throws NullPointerException if an argument is null
     * @throws ClassCastException   if the arguments' types prevent them from
     *                              being compared by this comparator.
     */
    @Override
    public int compare(Track o1, Track o2) {
        return Integer.compare(o1.getDuration(), o2.getDuration());
    }

    /**
     * the string representation is "by duration" (without quotes)
     *
     * @return a string representation of the object.
     */
    @Override
    public String toString() {
        return "by duration";
    }
}
